#include <bits/stdc++.h>

using namespace std;

typedef long long ll;
typedef long double ld;
typedef vector<int> vi;
typedef vector<vi> vvi;
typedef vector<ll> vl;
typedef vector<double> vd;
typedef vector<ld> vld;
typedef pair<int, int> pi;

const int maxn = 3e4 + 5;
vi e[maxn], g[maxn], s(maxn),vis1(maxn),vis2(maxn);

bool ok;
void dfs2(int x, int y){
    ++s[x];
    vis2[x] = 1;

    if (x == y){
        ok = 1;
        return;
    }
    for (auto& i : g[x]){
        if (vis2[i]) continue;
        dfs2(i,y);
        if (ok) return;
    }

    --s[x];
}

void dfs1(int x, int y){
    ++s[x];
    vis1[x] = 1;

    if (x == y){
        ok = 1;
        return;
    }
    for (auto& i : e[x]){
        if (vis1[i]) continue;
        dfs1(i,y);
        if (ok) return;
    }

    --s[x];
}

vi a={0}, b = {0};
void root1(int x){
    vis1[x] = 1;
    a.push_back(x);

    for (auto& i : e[x]){
        if (!vis1[i]){
            root1(i);
        }
    }
}

void root2(int x){
    vis2[x] = 1;
    b.push_back(x);

    for (auto& i : g[x]){
        if (!vis2[i]){
            root2(i);
        }
    }
}

void solve(int n, int q, int *u1, int *v1, int *u2, int *v2, int *a1, int *b1, int *c1, int *d1, int *r){
    for (int i = 1; i < n; ++i){
        e[u1[i]].push_back(v1[i]);
        e[v1[i]].push_back(u1[i]);
        g[v2[i]].push_back(u2[i]);
        g[u2[i]].push_back(v2[i]);
    }

    for (int i = 1; i <= n; ++i){
        int l = e[i].size();
        if (l == 1){
            root1(i);
            break;
        }
    }
    for (int i = 1; i <= n; ++i){
        int l = g[i].size();
        if (l == 1){
            root2(i);
            break;
        }
    }

    vi p1(n+1,0), p2 = p1;
    for (int i = 1; i <= n; ++i){
        p1[a[i]] = i;
        p2[b[i]] = i;
    }

    vvi blok1, blok2;
    int k = sqrt(n);
    vi t1, t2;
    for (int i = 1; i <= n; ++i){
        t1.push_back(a[i]);
        t2.push_back(b[i]);
        if (i % k == 0){
            blok1.push_back(t1);
            blok2.push_back(t2);
            t1.clear();
            t2.clear();
        }
    }

    vvi cnt(n/k+2, vi(n/k+2, 0));
    for (int i = 0; i <= (n-1)/k; ++i){
        vi c(n+1,0);
        for (int j = i*k+1; j <= (i+1)*k; ++j)
            c[a[j]] = 1;

        for (int j = 0; j <= (n-1)/k; ++j){
            for (int p = j*k+1; p <= (j+1)*k; ++p){
                if (c[b[p]]){
                    ++cnt[i][j];
                    ++cnt[j][i];
                }
            }
        }
    }

    vvi pref(n/k+2, vi(n/k+2, 0));
    for (int i = 0; i <= (n-1)/k; ++i){
        for (int j = 0; j <= (n-1)/k; ++j){
            if (!j){
                pref[i][0] = cnt[i][0];
            } else {
                pref[i][j] = pref[i][j-1] + cnt[i][j];
            }
        }
    }

    for (int i = 1; i <= q; ++i){
        for (int j = (a1[i]-1)/k+1; j < (b1[i]-1)/k; ++i){
            int last = (d1[i]-1)/k-1, fr = (c1[i]-1)/k+1;
            if (fr <= last){
                r[i] += pref[j][last];
                if (fr>0)
                    r[i] -= pref[j][fr-1];
            }
        }

        for (int j = a1[i]; j < ((a1[i]-1)/k+1)*k+1; ++j){
                int last = p2[d1[i]], fr = p2[c1[i]];
        if (fr > last) swap(fr, last);
            r[i] += ((p2[a[j]] >= fr) && (p2[a[j]] <= last));
        }

        for (int j = ((b1[i]-1)/k) * k + 1; j <= b1[i]; ++j){
            int last = p2[d1[i]], fr = p2[c1[i]];
            if (fr > last) swap(fr, last);
            r[i] += ((p2[b[j]] >= fr) && (p2[b[j]] <= last));
        }
    }
}


void Resi(int n, int q, int p, int *u1, int *v1, int *u2, int *v2, int *a1, int *b1, int *c1, int *d1, int *r){

    if (n>1000 || q > 1000){
        solve(n,q,u1,v1,u2,v2,a1,b1,c1,d1,r);
        return;
    }

    for (int i = 1; i < n; ++i){
        e[u1[i]].push_back(v1[i]);
        e[v1[i]].push_back(u1[i]);
        g[v2[i]].push_back(u2[i]);
        g[u2[i]].push_back(v2[i]);
    }

    for (int i = 1; i <= q; ++i){
        dfs1(a1[i],b1[i]);
        ok=0;
        dfs2(c1[i],d1[i]);
        ok = 0;
        r[i] = 0;

        for (int j = 1; j <= n; ++j){
            r[i] += (s[j] == 2);
            vis1[j] = vis2[j] = 0;
            s[j] = 0;
        }

    }
}